#!/bin/bash

# 定义数据文件列表
data_files=("FOLIO_train_modified.json" "LogicalDeduction_train_modified.json" "ProofWriter_train_modified.json" "gsm8k_alpaca_train.json")

# 设置基础路径
english_data_path="English_data"
chinese_data_paths=("Chinese_data_in_sequence" "Spanish_train_data" "French_train_data" "Hindi_train_data")
model_paths=("/home/Llama-3" "/data/microsoft_Phi-3-mini-4k-instruct" "/data/Qwen_Qwen2-7B-Instruct")
for model_path in ${model_paths[@]}; do
    model_name=$(basename "$model_path")
    # 定义显卡列表
    # gpus=(6)

    for chinese_data_path in ${chinese_data_paths[@]}; do
        # 遍历数据文件
        for i in "${!data_files[@]}"; do
            data=${data_files[i]}
            # gpu=${gpus[i]}
            
            echo "Processing ${data} on GPU ${gpu}..."
            
            lang=$(echo "$chinese_data_path" | awk -F'_' '{print $1}')
            task=$(echo "$data" | awk -F'.' '{print $1}')
            # 构造输出文件名
            output_file="${model_name}_${lang}_${task}"

            
            # 执行 Python 脚本并放入后台
            CUDA_VISIBLE_DEVICES=3 python find_reason_layers.py "${english_data_path}/${data}" "${chinese_data_path}/${data}" "${model_path}" "${output_file}" 1000 ${lang}
        done
    done
done
# 等待所有后台任务完成
wait

echo "All tasks completed."
